#!/bin/bash

export LC_ALL=POSIX
export LC_CTYPE=POSIX

if ! utils/check_build_env; then
        cd utils
        . ./build_env_init
        cd -
fi

prefix=${ACCROOTFS}
if [ -z "$prefix" ]; then
	echo "Error. \$ACCROOTFS not set."
	exit 1;
fi

cd ${ACCPROJ}
h=`sort ${ACCPROJ}/busybox.links | uniq`
cleanup="1"
noclobber="0"
linkopts="-fs"

if [ "$cleanup" = "1" ] && [ -e "$prefix/bin/busybox" ]; then
	#Backup busybox
	cp -f ${prefix}/bin/busybox ${ACCPROJ}/fs/
	inode=`ls -i "$prefix/bin/busybox" | awk '{print $1}'`
	sub_shell_it=`
	cd "$prefix"
	for d in usr/sbin usr/bin sbin bin; do
		pd=$PWD
		if [ -d "$d" ]; then
			cd $d
			ls -iL . | grep "^ *$inode" | awk '{print $2}' | xargs rm -f
		fi
		cd "$pd"
	done
	`
fi

#Restore busybox to rootfs
mv -f ${ACCPROJ}/fs/busybox ${prefix}/bin/busybox

for i in $h; do
	appdir=`dirname $i`
	mkdir -p $prefix/$appdir || exit 1
	if [ "$2" = "--hardlinks" ]; then
		bb_path="$prefix/bin/busybox"
	else
		case "$appdir" in
		/)
			bb_path="bin/busybox"
		;;
		/bin)
			bb_path="busybox"
		;;
		/sbin)
			bb_path="../bin/busybox"
		;;
		/usr/bin|/usr/sbin)
			bb_path="../../bin/busybox"
		;;
		*)
		echo "Unknown installation directory: $appdir"
		exit 1
		;;
		esac
	fi
	if [ "$noclobber" = "0" ] || [ ! -e "$prefix$i" ]; then
		echo "  $prefix$i -> $bb_path"
		ln $linkopts $bb_path $prefix$i || exit 1
	else
		echo "  $prefix$i already exists"
	fi
done

exit 0
